:: This script is a ndcli.exe command line -only package extractor
:: It extracts just the files needed for command line operation into new separate directory ndcli_only

@echo off
setlocal

:: Define the ANSI escape codes for colors
set green=[92m
set orange=[31m
set reset_color=[0m

:: Get the parent directory of the current script location
set "currentDir=%~dp0"
set "parentDir=%currentDir%.."

:: Read the first line of VERSION.txt into a variable
set "version="
for /f "usebackq delims=" %%A in ("%currentDir%NETCO_DEVICE_VERSION.txt") do (
    set "version=%%A"
    goto :done
)
:done

:: Check if version was read
if "%version%"=="" (
    echo %orange%ERROR: VERSION.txt is missing or empty! %reset_color%
    pause
    exit /b
)

:: Define target directory using the version string
set "targetDir=%parentDir%\ndcli_only_%version%"
for /f "delims=" %%A in ("%targetDir%") do set "absoluteTargetDir=%%~fA"

:: Check if the target directory already exists
if exist "%targetDir%" (
    echo %orange%The folder "%absoluteTargetDir%" already exists. No changes were made. %reset_color%
    pause
    exit /b
)

:: Create the versioned ndcli_only folder
mkdir "%targetDir%"

:: Copy specific folders (modify as needed)
xcopy "%currentDir%\backend" "%targetDir%\backend" /E /I /Y

:: Copy specific files (modify as needed)
copy "%currentDir%\ndcli.exe" "%targetDir%\" /Y
copy "%currentDir%\NETCO_DEVICE_BUILDINFO.json" "%targetDir%\" /Y
copy "%currentDir%\NETCO_DEVICE_VERSION.txt" "%targetDir%\" /Y
copy "%currentDir%\NETCO_DEVICE_VERSION.txt" "%targetDir%\" /Y
copy "%currentDir%\package.json" "%targetDir%\" /Y


echo %green% Files and folders copied successfully to:%reset_color%
echo %green% %absoluteTargetDir% %reset_color%
pause

